/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.layers;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.views.pagination.Page;
import net.impactdev.impactor.api.ui.containers.views.pagination.updaters.PageUpdater;
import net.impactdev.impactor.api.ui.containers.views.pagination.updaters.PageUpdaterType;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.PaginatedView;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector2i;
import net.kyori.adventure.util.TriState;

public class ImpactorPage
implements Page {
    private final int index;
    private final Map<Integer, Icon> icons;

    public ImpactorPage(ImpactorPageBuilder builder) {
        this.index = builder.index;
        this.icons = this.craft(builder);
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public Map<Integer, Icon> icons() {
        return this.icons;
    }

    private Map<Integer, Icon> craft(ImpactorPageBuilder builder) {
        HashMap results = Maps.newHashMap();
        builder.updaters.forEach(updater -> {
            switch (updater.type()) {
                case PREVIOUS: 
                case FIRST: {
                    if (this.index != 1 || builder.style != TriState.FALSE) break;
                    return;
                }
                case NEXT: 
                case LAST: {
                    if (this.index != builder.pages || builder.style != TriState.FALSE) break;
                    return;
                }
            }
            int target = updater.type().translate(this.index, builder.pages);
            Icon icon = (Icon)Icon.builder().display(() -> updater.provider().provide(target)).listener(processor -> {
                if (!updater.type().equals((Object)PageUpdaterType.CURRENT)) {
                    if (target == this.index) {
                        return false;
                    }
                    builder.view.page(target);
                }
                return false;
            }).build();
            results.put(updater.slot(), icon);
        });
        int slot = 0;
        for (Icon icon : builder.contents) {
            results.put(this.calculateTargetSlot(slot++, builder.zone, builder.offsets), icon);
        }
        while (slot < builder.zone.x() * builder.zone.y()) {
            results.put(this.calculateTargetSlot(slot, builder.zone, builder.offsets), (Icon)Icon.builder().display(ImpactorItemStack::empty).build());
            ++slot;
        }
        return results;
    }

    private int calculateTargetSlot(int target, Vector2i zone, Vector2i offsets) {
        int x = target % zone.x();
        int y = target / zone.x();
        Vector2i result = Vector2i.from(x, y).add(offsets);
        return result.x() + 9 * result.y();
    }

    public static ImpactorPageBuilder builder() {
        return Impactor.instance().builders().provide(ImpactorPageBuilder.class);
    }

    public static class ImpactorPageBuilder
    implements Builder<ImpactorPage> {
        private List<Icon> contents = Collections.EMPTY_LIST;
        private int index;
        private PaginatedView view;
        private Set<PageUpdater> updaters;
        private int pages;
        private Vector2i zone;
        private Vector2i offsets;
        private TriState style;

        public ImpactorPageBuilder contents(List<Icon> icons) {
            this.contents = icons;
            return this;
        }

        public ImpactorPageBuilder index(int index) {
            this.index = index;
            return this;
        }

        public ImpactorPageBuilder parent(PaginatedView view) {
            this.view = view;
            return this;
        }

        public ImpactorPageBuilder updaters(Set<PageUpdater> updaters) {
            this.updaters = updaters;
            return this;
        }

        public ImpactorPageBuilder pages(int pages) {
            this.pages = pages;
            return this;
        }

        public ImpactorPageBuilder zone(Vector2i zone) {
            this.zone = zone;
            return this;
        }

        public ImpactorPageBuilder offsets(Vector2i offsets) {
            this.offsets = offsets;
            return this;
        }

        public ImpactorPageBuilder style(TriState style) {
            this.style = style;
            return this;
        }

        @Override
        public ImpactorPage build() {
            return new ImpactorPage(this);
        }
    }
}

